class TDM_SB extends TournamentScoreBoard;

var localized string TeamName[4];
var localized string OrdersString, InString;
var localized string PlayersNotShown;
var() color TeamColor[4];
var() color AltTeamColor[4];
var PlayerReplicationInfo OwnerInfo;
var TournamentGameReplicationInfo OwnerGame;

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL;
}

function ShowScores( canvas Canvas )
{
local PlayerReplicationInfo PRI;
local int PlayerCount, i;
local float LoopCountTeam[4];
local float XL, YL, XOffset, YOffset, XStart;
local int PlayerCounts[4];
local int LongLists[4];
local int BottomSlot[4];
local font CanvasFont;
local bool bCompressed;
local float redx,bluex,greenx,goldx,redy,bluey,greeny,goldy;
local Color PlayerColor;
local bool bGreenTeam, bGoldTeam;
local int RedScore, BlueScore, GreenScore, GoldScore;

	OwnerInfo = Pawn(Owner).PlayerReplicationInfo;
	OwnerGame = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);	
	Canvas.Style = ERenderStyle.STY_Normal;
	CanvasFont = Canvas.Font;

	redx = Canvas.ClipX * 0.5 - 350;
	bluex = Canvas.ClipX * 0.5 + 50;
	greenx = redx;
	goldx = bluex;

	redy = 130;
	bluey = redy;
	greeny = Canvas.ClipY * 0.5 + 20;
	goldy = greeny;

	for ( i=0; i<32; i++ )
		Ordered[i] = None;

	for ( i=0; i<32; i++ )
		{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
			{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
				{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PRI.Team == 0 )
					{
					RedScore += PRI.Score;
					RedScore -= PRI.Deaths;
					}
				else if ( PRI.Team == 1 )
					{
					BlueScore += PRI.Score;
					BlueScore -= PRI.Deaths;
					}
				else if ( PRI.Team == 2 )
					{
					GreenScore += PRI.Score;
					GreenScore -= PRI.Deaths;
					bGreenTeam = True;
					}
				else if ( PRI.Team == 3 )
					{
					GoldScore += PRI.Score;
					GoldScore -= PRI.Deaths;
					bGoldTeam = True;
					}
				}
			}
		}

	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("TEXT", XL, YL);

	//Draw Red team scores:
	Canvas.DrawColor = RedColor;
	Canvas.SetPos(redx, redy - YL);
	Canvas.DrawText(PRI(PlayerPawn(Owner).PlayerReplicationInfo).RedTeamName@RedScore, false);
	//Draw Blue team scores:
	Canvas.DrawColor = BlueColor;
	Canvas.SetPos(bluex, bluey - YL);
	Canvas.DrawText(PRI(PlayerPawn(Owner).PlayerReplicationInfo).BlueTeamName@BlueScore, false);
	if ( bGreenTeam )
		{
		//Draw Green team scores:
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(greenx, greeny - YL);
		Canvas.DrawText(PRI(PlayerPawn(Owner).PlayerReplicationInfo).GreenTeamName@GreenScore, false);
		}
	if ( bGoldTeam )
		{
		//Draw Gold team scores:
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(goldx, goldy - YL);
		Canvas.DrawText(PRI(PlayerPawn(Owner).PlayerReplicationInfo).GoldTeamName@GoldScore, false);
		}	


	SortScores(PlayerCount);
	YL = 36;

	for ( I=0; I<PlayerCount; I++ )
		{
		if ( Ordered[I].Team < 4 )
			{
			if ( Ordered[I].Team == 0 )
				{
				XOffset = redx;
				YOffset = redy;
				redy += YL;
				PlayerColor = RedColor;
				}
			else if ( Ordered[I].Team == 1 )
				{
				XOffset = bluex;
				YOffset = bluey;
				bluey += YL;
				PlayerColor = BlueColor;
				}
			else if ( Ordered[I].Team == 2 )
				{
				XOffset = greenx;
				YOffset = greeny;
				greeny += YL;
				PlayerColor = GreenColor;
				}
			else
				{
				XOffset = goldx;
				YOffset = goldy;
				goldy += YL;
				PlayerColor = GoldColor;
				}
			DrawPlayers( Canvas, Ordered[I], XOffset, YOffset, bCompressed, PlayerColor);
			}
		}
	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.Font = CanvasFont;
	Canvas.DrawColor = WhiteColor;
	//DrawHeader(Canvas);
	DrawVictoryConditions(Canvas);
}

function DrawPlayers(Canvas Canvas, PlayerReplicationInfo PRInfo, float XOffset, float YOffset, bool bCompressed, Color PlayerColor)
{
local float XL, YL, XL2, YL2, YB;
local String S, O, L;
local Font CanvasFont;
local int Time;
local int Frags, Deaths, Score;
local float Eff;
local Texture Flag;
local string ImportTexture, PName;

	if ( Len(PRInfo.PlayerName) > 14 )
		PName = Left(PRInfo.PlayerName,14);
	else
		PName = PRInfo.PlayerName;

	//Draw Background
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 50;
	Canvas.DrawColor.G = 50;
	Canvas.DrawColor.B = 50;
	Canvas.SetPos( XOffset - 51, YOffset );
	Canvas.DrawTile(Texture'FrameDot', 397, 34, 0, 0, 2, 2);
	Canvas.Style = ERenderStyle.STY_Normal;

	Frags = PRInfo.Score;
	Deaths = PRInfo.Deaths;
	Score = Frags - Deaths;

	// Draw Name
	if ( PRInfo.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else
		Canvas.DrawColor = PlayerColor;

	Canvas.SetPos(XOffset, YOffset + 4);
	Canvas.DrawText(PName, False);
	Canvas.SetPos(XOffset + 180, YOffset + 4);
	Canvas.DrawText("F:"@Frags$" D:"@Deaths$" S:"@Score, False);

	CanvasFont = Canvas.Font;
	Canvas.Font = Font'SmallFont';
	Canvas.DrawColor = WhiteColor;

	if (!PRInfo.bIsABot)
		{
		if ( Canvas.ClipX > 800 )
			{
			// Draw Time
			Time = Max(1, (Level.TimeSeconds + PlayerPawn(Owner).PlayerReplicationInfo.StartTime - PRInfo.StartTime)/60);
			Canvas.StrLen(TimeString$":     ", XL, YL);
			if ( PRInfo.Team == 0 || PRInfo.Team == 2 )
				Canvas.SetPos(XOffset - XL - 60, YOffset + 4);
			else
				Canvas.SetPos(XOffset +350, YOffset + 4);
			Canvas.DrawText(TimeString$":"@Time, false);

			Canvas.StrLen(PingString$":     ", XL2, YL2);
			if ( PRInfo.Team == 0 || PRInfo.Team == 2 )
				Canvas.SetPos(XOffset - XL2 - 60, YOffset + (YL+5));
			else
				Canvas.SetPos(XOffset + 350, YOffset + (YL+5));
			Canvas.DrawText(PingString$":"@PRInfo.Ping, false);

			Eff = (PRInfo.Score - PRInfo.Deaths) / PRInfo.Score * 100;
			Canvas.StrLen("Eff: 100%", XL2, YL2);
			if ( PRInfo.Team == 0 || PRInfo.Team == 2 )
				Canvas.SetPos(XOffset - XL2 - 60, YOffset + (2*YL+5));
			else
				Canvas.SetPos(XOffset + 350, YOffset + (2*YL+5));
			Canvas.DrawText("Eff:"@int(Eff)$"%", false);
			}
		}
	Canvas.Font = CanvasFont;

	//Draw Country Flag:
	if ( PRInfo.bIsABot )
		{
		Canvas.SetPos(XOffset - 50, YOffset + 1);
		Canvas.DrawTile(Texture'BotFlag', 48, 32, 0, 0, 48, 32);
		}
	else if ( PRI(PRInfo).Country != "" )
		{
		ImportTexture = "MOS_HASM_v1.Flags."$PRI(PRInfo).Country;
		Flag = texture(DynamicLoadObject(ImportTexture, class'Texture'));
		Canvas.SetPos(XOffset - 50, YOffset + 1);
		if ( Flag != None )
			Canvas.DrawTile(Flag, 48, 32, 0, 0, 48, 32);
		}
	else
		{
		Canvas.SetPos(XOffset - 50, YOffset + 1);
		Canvas.DrawTile(Texture'NoFlag', 48, 32, 0, 0, 48, 32);
		}
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.bCenter=True;
	Canvas.SetPos(0, 0 );
	Canvas.DrawText(TGRI.GameName);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, YL);

	if ( TGRI.GoalTeamScore > 0 )
		{
		Canvas.DrawText(FragGoal@TGRI.GoalTeamScore);
		Canvas.StrLen("Test", XL, YL);
		YL += YL;
		Canvas.SetPos(0, YL);
		}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
	Canvas.bCenter=False;
}

function SortScores(int N)
{
local int I, J, Max;
local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
		{
		Max = I;
		for ( J=I+1; J<N; J++ )
			{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
			}
		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
		}
}

defaultproperties
{
     TeamName(0)=""
     TeamName(1)=""
     TeamName(2)=""
     TeamName(3)=""
     OrdersString="Orders:"
     InString="Location:"
     PlayersNotShown="Player[s] not shown."
     TeamColor(0)=(R=255)
     TeamColor(1)=(G=128,B=255)
     TeamColor(2)=(G=255)
     TeamColor(3)=(R=255,G=255)
     AltTeamColor(0)=(R=200)
     AltTeamColor(1)=(G=94,B=187)
     AltTeamColor(2)=(G=128)
     AltTeamColor(3)=(R=255,G=255,B=128)
}
